#ifndef __ADC_H__
#define __ADC_H__

#include <unistd.h>

extern void adc_open(void);

extern ssize_t adc_read(void *buf, size_t count);

extern ssize_t adc_write(const void *buf, size_t count);

extern off_t adc_lseek(off_t offset, int whence);

struct adc_file
{
	float p_curt;
	float n_curt;
	float p_volt;
	float n_volt;
	int p_curt_gain;
	int p_volt_gain;
	int n_curt_gain;
	int n_volt_gain;

	int rtd_type;
	int wire_mode;
	float temp;

	unsigned long adc0_hit;
	unsigned long adc1_hit;
};

#endif
